import java.util.Hashtable;

// Classe de gestion des ressources.
public class ResourceBundle {

  // Liste des objets.
  private static Hashtable groups = new Hashtable(); 

  // Retourne l'objet recherch.
  public static Object getObject (String group, String key) {
    ResourceBundle bundle;
    synchronized (groups) {
      bundle = (ResourceBundle) groups.get (group);
      // Si l'objet n'est pas trouv dans la table "groups", la charger.
      if (bundle == null) {
        bundle = loadBundle (group);
      }
    }
    // Recherche et retourne la ressource associe  l'objet trouv.
    return bundle.getResource (key);
  }

  // Retourne l'objet recherch au format String (chane de caractres).
  public static String getString (String group, String key) {
    return (String) getObject (group, key);
  }

  // Charge une ressource : la recherche d'abord dans l'existant,
  // en cre une si aucune n'est trouve.
  public static ResourceBundle loadBundle (String name) {
    ResourceBundle bundle = null;
    Locale locale = Locale.getDefaultLocale();
    String language = locale.getLanguage();
    String country = locale.getCountry();
    // Regarde si un objet de mme nom existe dj.
    // Si c'est le cas, en charge une instance.
    try {
      bundle = (ResourceBundle) Class.forName (name).newInstance();
    }
    catch (Exception e) {
    }
    // Vrifie qu'une langue est bien slectionne.
    if (language != null) {
      ResourceBundle child;
      try {
        // Regarde si un objet de mme nom existe dj pour cette langue.
        // Si c'est le cas, en charge une instance.
        child = (ResourceBundle) Class.forName (name + '_' + 
                language).newInstance();
        child.setParent (bundle);
        bundle = child;
      }
      catch (Exception e) {
      }
      // Vrifie qu'un pays est bien slectionn.
      if (country != null) {
        try {
          // Regarde si un objet de mme nom existe dj pour cette
          // langue et pour ce pays.
          // Si c'est le cas, en charge une instance.
          child = (ResourceBundle) Class.forName (name + '_' + language + '_' + 
                  country).newInstance();
          child.setParent (bundle);
          bundle = child;
        } catch (Exception e) {
        }
      }
    }
    // Si aucune langue si aucun pays n'a t slectionn, on cre l'objet.
    if (bundle == null) {
      bundle = new ResourceBundle();
    }
    // Associe l'objet slectionn au nom "name".
    groups.put (name, bundle);
    return bundle;
  }

  // Liste des ressources
  protected Hashtable resources = new Hashtable();

  // Dsigne la ressource parent
  private ResourceBundle parent;

  protected ResourceBundle() {
  }

  // Retourne une rfrence vers la ressource parent.
  protected void setParent (ResourceBundle parent) {
    this.parent = parent;
  }

  // Recherche la ressource dont le nom est fourni dans le paramtre "key".
  // Au besoin fait appel au parent.
  protected Object getResource (String key) {
    Object obj = null;
    // Tente de trouver la ressource dans cet objet.
    if (resources != null) {
      obj = resources.get (key);
    }
      // S'il n'a pas t trouv, procder  la recherche chez le parent.
    if (obj == null && parent != null) {
      obj = parent.getResource (key);
    }
    return obj;
  }

  // Classe de gestion de la langue et du pays.
  public static class Locale {
    private String language = "en";
    private String country = "US";
    
    // Spcifie la langue et le pays courants.
    public Locale( String language, String country ) {
      this.language = language;
      this.country = country;
    }

    // Spcifie la langage et le pays courants  partir d'une variable
    // contenant "langue - pays".
    public Locale (String locale) {
      if (locale != null) {
        int pos = locale.indexOf ('-');
        if (pos != -1) {
          // Extrait la partie  gauche du tiret : c'est la langue.
          language = locale.substring (0, pos);
          locale = locale.substring (pos + 1);
          // Extrait la partie  droite du tiret : c'est le pays.
          // Si un second tiret est trouv, l'liminer ainsi que
          // tout ce qui se trouve  sa droite.
          pos = locale.indexOf ('-');
          if (pos == -1) {
            country = locale;
          } else {
            country = locale.substring (0, pos);
          }
        }
      }
    }

    // Retourne la langue courante.
    public String getLanguage() {
      return language;
    }

    // Retourne le pays courant.
    public String getCountry() {
      return country;
    }

    // Spcifie comme langue et pays courants la locale du terminal utilise.
    private static Locale defaultLocale = new Locale
           (System.getProperty ("microedition.locale"));

    // Retourne la locale (contenant la langue et le pays) par dfaut,
    // c'est--dire tels que retourns par le terminal.
    public static Locale getDefaultLocale() {
      return defaultLocale;
    }

    // Modifie la locale par dfaut.
    public static void setDefaultLocale (Locale locale) {
      defaultLocale = locale;
    }
  }
}
